#include "stdafx.h"
#include "GSolve.h"
#include "GException.h"

void matrix_inverse(vector<vector<double>>& A, vector<vector<double>>& invA){
	int n = A.size();
	vector<double> tmp(2*n,0);
	vector<vector<double>> mat(2*n,tmp);

	for(int i=0;i<n;i++){
		for(int j=0;j<2*n;j++)
			if(j<n) mat[i][j]=A[i][j];
			mat[i][n+i]=1;
		}
	
	double det=1;//il sera gal au produit des pivots
	int cpt_permutations=0;
	for(int k=0;k<n;k++){

			double tmp = mat[k][k];//pivot
			double max=1e-6;
					int index_max=-1;
					for(int i=k;i<n;i++){
						if(abs(mat[i][k])>max) {max=abs(mat[i][k]);index_max=i;}

					}
					if(index_max==-1) {
							cout<<" matrice non inversible "<<endl;
							exit(-1);


						}
					else if(index_max>k){
						for(int j=0;j<2*n;j++){
							double temp=mat[k][j];
							mat[k][j]=mat[index_max][j];
							mat[index_max][j]=temp;
						}
							cpt_permutations++;
					}
					
					tmp = mat[k][k];
					det*=tmp;
					for (int j=(2*n-1);j>=k;j--)
						mat[k][j]=mat[k][j]/tmp;//pour avoir pivot==1
					

				
			for(int i=0;i<n;i++){
			        if(i!=k){
					double tmp = mat[i][k];
					for (int j=(2*n-1);j>=k;j--)
						mat[i][j]=mat[i][j]-tmp*mat[k][j];//pour mettre des 0 dans la colonne du pivot
					}
			
			}

			


	}
	

	
	for(int i=0;i<n;i++)
		for(int j=0;j<n;j++)
			invA[i][j]=mat[i][j+n];

	if(cpt_permutations %2==1) det = -det;
	

}

GMatrix pinv(GMatrix& G){
	GMatrix res;
	int m = G.getNbLines();
	int n = G.getNbColumns();
	GMatrix A;

	bool transpose = false;
	if(m<n){
		transpose = true;
		A=G*(~G);
		n=m;
	}
	else {
		A=(~G)*G;
	}

	double tol=1e15;
	for(int i =1;i<=A.getNbLines();i++)
		if((A(i,i)>0)&&(A(i,i)<tol)) tol = A(i,i); 
    tol = tol*1e-9;
    
	GMatrix L(A.getNbLines(),A.getNbColumns());

	for(int i = 1;i<=A.getNbLines();i++)
		for(int j = 1;j<=A.getNbColumns();j++)
			L(i,j)=0;
	int r = 0;
	for(int k=1;k<=n;k++){
		r++;
		GMatrix U(n-k+1,r-1);
		for(int i =1;i<=(n-k+1);i++)
			for(int j =1;j<=(r-1);j++)
				U(i,j)=L(i+k-1,j);
		GVector V(r-1);
		for(int i=1;i<=(r-1);i++)
			V(i)=L(k,i);
		GVector W(n-k+1);
		W=U*V;
		for(int i=k;i<=n;i++)
			L(i,r)=A(i,k)-W(i-k+1);
		
		if(L(k,r)>tol){
			L(k,r)=sqrt(L(k,r));
			if(k<n){
				for(int i=k+1;i<=n;i++)
					L(i,r)=L(i,r)/L(k,r);
			}
		}
		else r--;
	}//end for k
    
	GMatrix Lp(L.getNbLines(),r);
	for(int i=1; i<=L.getNbLines();i++)
		for(int j=1;j<=r;j++)
			Lp(i,j)=L(i,j);
	GMatrix N(r,r);
	N=(~Lp)*Lp;
	vector<double> tmp(r,0);
	vector<vector<double>> Nv(r,tmp);
	for(int i=0;i<r;i++)
		for(int j=0;j<r;j++)
			Nv[i][j]=N(i+1,j+1);
	vector<vector<double>> Mv(r,tmp);
	matrix_inverse(Nv,Mv);
	
	GMatrix M(r,r);
	for(int i=1;i<=r;i++)
		for(int j=1;j<=r;j++)
			M(i,j)=Mv[i-1][j-1];



	if(transpose)
		res = (~G)*Lp*M*M*(~Lp);
	else 
		res = Lp*M*M*(~Lp)*(~G);

return res;
}

//=====================================================
//  GSolve definition
//=====================================================

GSolve::GSolve(const GMatrix &a, const GVector &m,short method) 
{
	_lines=a.getNbLines();
	_columns = a.getNbColumns();

	
	if (_lines>=_columns && m.size() == _lines)
	{
		_isValid = true;
		
		switch (method){

		case 1 : 
		    orthogonalize(a,m);
			break;

		case 2 : 
		    orthogonalizeM(a,m);
			break;

		case 3 :
		    householder(a,m);
			break;

		case 4 :
		    givens(a,m);
			break;
		case 5 :
			orthogonalize2(a,m);
			break;
		default :
			
		    orthogonalize(a,m);
			break;

		}
	}
	else
	{   	
		_isValid = false;
		throw (GException("GSOLVE","GSolve::GSolve(const GMatrix &a, const GVector &m)","_lines<_columns"));
	}
}


GSolve::GSolve(const GMatrix &a, const GVector &m, int nblines,short method) 
{
	// nblines doit tre entre 0 et a.getNbLines()
	if ((nblines <=0) || (nblines > a.getNbLines()))
		_lines=a.getNbLines();
	else 
		_lines=nblines;

	_columns = a.getNbColumns();

	if (_lines==a.getNbLines())
	{
		// comportement identitique au premier constructueur
		if (_lines>=_columns && m.size() == _lines)
		{
			_isValid = true;
			switch (method){

		case 1 : 
		    orthogonalize(a,m);
			break;

		case 2 : 
		    orthogonalizeM(a,m);
			break;

		case 3 :
		    householder(a,m);
			break;

		case 4 :
		    givens(a,m);
			break;
		case 5 :
			orthogonalize2(a,m);
			break;
		default :
			
		    orthogonalize(a,m);
			break;

		}
		}
		else
		{   	
			_isValid = false;
			throw (GException("GSOLVE","GSolve::GSolve(const GMatrix &a, const GVector &m)","_lines<_columns"));
		}
	}
	else 
	{
		// on transfre vers une structure plus petite et on fait le mme traitement
		GMatrix abis(_lines, _columns);
		GVector mbis(_lines);

		for(int i=1;i<=_lines;i++){ 
			abis.setLine(i,a.getLine(i));
			mbis(i) = m(i);	
		}

		if (_lines>=_columns && mbis.size() == _lines)
		{
			_isValid = true;
			switch (method){

		case 1 : 
		    orthogonalize(abis,mbis);
			break;

		case 2 : 
		    orthogonalizeM(abis,mbis);
			break;

		case 3 :
		    householder(abis,mbis);
			break;

		case 4 :
		    givens(abis,mbis);
			break;

		case 5 : 
		    orthogonalize2(abis,mbis);
			break;

		default :
			
		    orthogonalize(abis,mbis);
			break;

		}
		}
		else
		{   	
			_isValid = false;
			throw (GException("GSOLVE","GSolve::GSolve(const GMatrix &a, const GVector &m)","_lines<_columns"));
		}
	}
}


GSolve::~GSolve()
{

}

bool GSolve::isValid()
{
	return _isValid;
}

GVector& GSolve::result()
{
	return _r;
}

void GSolve::orthogonalize(const GMatrix& a, const GVector& m)
{
	//FILE *f = fopen("orthogonalize.log","a");
	
	//fprintf(f,"Size of A : %d lines, %d columns\n", a.getNbLines(), a.getNbColumns());

	//for (int o=1; o<=_lines; o++)
	//{
	//	for (int p=1; p<=_columns; p++)
	//		fprintf(f,"A[%d,%d]= %g\t", o, p,  a(o,p));
	//	fprintf(f,"\n");
	//}

	int i, j, k;
	double value, norm, tmpSum;
	GVector tmpVector(_lines);
	GVector tmpNorm(_columns);
	GMatrix tmpLambda(_columns, _columns);
	_b = GMatrix(_lines, _columns);
	_p = GMatrix(_columns, _columns);
	_r = GVector(_columns);

	for (i=1; i<=_columns; i++)
	{
		tmpVector = a.getColumn(i);

		//for (int o=1; o<=_lines; o++) fprintf(f,"A[%d - %d] = %f\n", i, o, tmpVector(o));

		for (j=1; j<=i; j++)
		{
			value = a.getColumn(i) * _b.getColumn(j);

			//fprintf(f,"value i=%d  j=%d -> %g\n", i, j, value);

			tmpVector -= value * (_b.getColumn(j));
			tmpLambda(j,i) = value;
		}
		norm = !tmpVector;

		//fprintf(f,"%g\n", norm);

		tmpVector = (tmpVector/(_isnan(norm)?1.0:norm));  // ici
		_b.setColumn(i,tmpVector);
		tmpNorm(i) = (_isnan(norm)?1.0:norm);   // ici
	}

	for (i=1; i<=_columns; ++i)
	{
		_p(i,i) = 1/tmpNorm(i);
	}
	for (i=2; i<= _columns; ++i)
	{
		for (j=1; j<= (i-1); ++j)
		{
			tmpSum = double(0);
			for (k=j; k<=i-1; ++k)
			{
				tmpSum += tmpLambda(k,i)* _p(j,k);
			}
			_p(j,i) = -tmpSum/tmpNorm(i);
			_p(i,j)= 0;
		}
	}

	for (i=1; i<=_columns; i++)
	{
		value = m * _b.getColumn(i);
		tmpNorm(i) = value;
	}
	_r = _p*tmpNorm;

	//fclose(f);
}

void GSolve::orthogonalize2(const GMatrix& a, const GVector& m)
{
	//FILE *f = fopen("orthogonalize.log","a");
	
	//fprintf(f,"Size of A : %d lines, %d columns\n", a.getNbLines(), a.getNbColumns());

	//for (int o=1; o<=_lines; o++)
	//{
	//	for (int p=1; p<=_columns; p++)
	//		fprintf(f,"A[%d,%d]= %g\t", o, p,  a(o,p));
	//	fprintf(f,"\n");
	//}

	int i, j, k;
	double value, norm, tmpSum;
	GVector tmpVector(_lines);
	GVector tmpNorm(_columns);
	GMatrix tmpLambda(_columns, _columns);
	_b = GMatrix(_lines, _columns);
	_p = GMatrix(_columns, _columns);
	_r = GVector(_columns);

	for (i=1; i<=_columns; i++)
	{
		tmpVector = a.getColumn(i);

		//for (int o=1; o<=_lines; o++) fprintf(f,"A[%d - %d] = %f\n", i, o, tmpVector(o));

		for (j=1; j<=i; j++)
		{
			value = a.getColumn(i) * _b.getColumn(j);

			//fprintf(f,"value i=%d  j=%d -> %g\n", i, j, value);

			tmpVector -= value * (_b.getColumn(j));
			tmpLambda(j,i) = value;
		}
		norm = !tmpVector;

		//fprintf(f,"%g\n", norm);

		tmpVector = (tmpVector/(_isnan(norm)?1.0:norm));  // ici
		_b.setColumn(i,tmpVector);
		tmpNorm(i) = (_isnan(norm)?1.0:norm);   // ici
	}

	for(int i=1;i<=_columns;i++)
		tmpLambda(i,i)=tmpNorm(i);

	_p = pinv(tmpLambda);
	for (i=1; i<=_columns; i++)
	{
		value = m * _b.getColumn(i);
		tmpNorm(i) = value;
	}
	_r = _p*tmpNorm;

	//fclose(f);
}

void GSolve::orthogonalizeM(const GMatrix &a, const GVector &m){

    int i, j, k;
	double value, norm, tmpSum;

	GVector tmpNorm(_columns);
	GMatrix tmpLambda(_columns, _columns);
	_b = GMatrix(_lines, _columns);
	_p = GMatrix(_columns, _columns); //inverse de la matrice R obtenue par la QR
	_r = GVector(_columns);

	_b=a;

	for (i=1; i<=_columns; ++i)
	  {

		norm=0.0;
		for(int k=1;k<=_lines;k++)
			norm+=_b(k,i)*_b(k,i);

		norm=sqrt(norm);

        for(int k=1;k<=_lines;k++)
		    _b(k,i)=_b(k,i)/norm;

		tmpNorm(i) = norm;

		for(j=i+1;j<=_columns;++j)
		  {

            value=0.0;
			for(int k=1;k<=_lines;k++)
				value+=_b(k,j)*_b(k,i);
			for(int k=1;k<=_lines;k++)
				_b(k,j)-=value*_b(k,i);

			tmpLambda(i,j) = value;
		 }

	}
	

    for (i=1; i<=_columns; ++i)
	  {
		_p(i,i) = 1/tmpNorm(i);
	  }
	for (i=2; i<= _columns; ++i)
	{
		for (j=1; j<= (i-1); ++j)
		{
			tmpSum = double(0);
			for (k=j; k<=i-1; ++k)
			{
				tmpSum += tmpLambda(k,i)* _p(j,k);
			}
			_p(j,i) = -tmpSum/tmpNorm(i);
			_p(i,j)= 0;
		}
	}


	for (i=1; i<=_columns; i++)
	{
		value=0.0;
		for(int j=1;j<=_lines;j++) value+=m(j)*_b(j,i);

		tmpNorm(i) = value;
	}


	_r = _p*tmpNorm;
}

void GSolve::householder(const GMatrix &a, const GVector &m){
    double signv;
	double tmpSum;
	
	
	_p = GMatrix(_columns, _columns);
	
	
	GVector Qm(m);
	GMatrix R(a);
	
	GVector v(_lines);
	for(int k=1;k<=_columns;k++){
		
	
	    

	    for(int i=k;i<=_lines;i++)v(i)=R(i,k);
		
		for(int i=1;i<k;i++) v(i)=0;
		
		signv=(v(k)>=0)? 1.0 : -1.0;
		double tmpnorm=0.0;
		double norm1=0.0;
		double norm2=0.0;

		for(int j=k;j<=_lines;j++)
			tmpnorm+=v(j)*v(j);
		norm1=sqrt(tmpnorm);
        norm2=sqrt(tmpnorm-v(k)*v(k)+
			(v(k)+signv*norm1)*(v(k)+signv*norm1));
		v(k) += signv*norm1;
		for(int j=k;j<=_lines;j++)
		v(j)=v(j)/norm2;

       //Calcul du vecteur Qm
       double tmp=0.0;
       for(int j=k;j<=_lines;j++)
		  tmp+=v(j)*Qm(j);
	   for(int j=k;j<=_lines;j++)
		   Qm(j)-=2*tmp*v(j);


       //Calcul de la matrice R
	   GVector w(_columns);//vecteur temporaire 
	   for(int l=k;l<=_columns;l++)
			 for(int j=k;j<=_lines;j++)
				 w(l)+=R(j,l)*v(j);
       for(int l=k;l<=_lines;l++)
			 for(int j=k;j<=_columns;j++)
                 R(l,j)-=2*v(l)*w(j);
	}

	
	for (int i=1; i<=_columns; ++i)
	{
		_p(i,i) = 1/R(i,i);
	}
	for (int i=2; i<= _columns; ++i)
	{
		for (int j=1; j<= (i-1); ++j)
		{
			tmpSum = double(0);
			for (int k=j; k<=i-1; ++k)
			{
				tmpSum += R(k,i)* _p(j,k);
			}
			_p(j,i) = -tmpSum/R(i,i);
			_p(i,j)= 0;
		}
	}

	
	
	GVector tmp(_columns);
	for(int i =1;i<=_columns;i++)
		tmp(i)=Qm(i);
	_r = _p*tmp;

   
}


void GSolve::givens(const GMatrix &a, const GVector &m){

   
     GMatrix R(a);

	_p = GMatrix(_columns, _columns); //inverse de la matrice R obtenue par la QR
	_r = GVector(_columns);

	
	GVector tQm(m);//correspond  transpose(Q)*m
    double tmpSum;

    for(int k1 = 1;k1<=_columns-1;k1++){
		for(int k2=_lines-1;k2>=k1;k2--){

			double x = R(k2,k1);
			double y = R(k2+1,k1);

			if(y!=0){

				double rho = sqrt(x*x+y*y);
				double Cos = x/rho;
				double Sin = y/rho;

				R(k2,k1)=rho;

				R(k2+1,k1)=0.0;

				for(int u =k1+1;u<=_columns;u++){
					double R_aux = Cos*R(k2,u) + Sin*R(k2+1,u);
					R(k2+1,u) = -Sin*R(k2,u) + Cos*R(k2+1,u);
					R(k2,u) = R_aux;

				}
				//////////////////////////////////////////
				double tQb_aux = Cos*tQm(k2) + Sin*tQm(k2+1);
				tQm(k2+1) = -Sin*tQm(k2) + Cos*tQm(k2+1);
				tQm(k2) = tQb_aux;
				/////////////////////////////////////////


			}//if
		}//for(k2)
	}//for(k1)

   for (int i=1; i<=_columns; ++i)
	{
		_p(i,i) = 1/R(i,i);
	}
	for (int i=2; i<= _columns; ++i)
	{
		for (int j=1; j<= (i-1); ++j)
		{
			tmpSum = double(0);
			for (int k=j; k<=i-1; ++k)
			{
				tmpSum += R(k,i)* _p(j,k);
			}
			_p(j,i) = -tmpSum/R(i,i);
			_p(i,j)= 0;
		}
	}

	
 
   GVector tmp(_columns);
	for(int i =1;i<=_columns;i++)
		tmp(i)=tQm(i);
	_r = _p*tmp;

}

//Les indices des colonnes dpendants commencent de 1
bool GSolve::verify_rank(const GMatrix& a, int& rank, vector<int>& dependent_columns){
	bool complete_rank;

	GMatrix M(a);
	int m = M.getNbLines();
	int n = M.getNbColumns();
	int i=1,j=1;
	bool end = false;
	int cpt = 0;
	while((i<=m)&&(j<=n)){
		
		cpt++;
		
		bool test = false;
		int i0;
		while(!test&&(j<=n)){
			double max = 1e-10;
			for(int k=i;k<=m;k++)
				if(abs(M(k,j))>max){i0=k; max = abs(M(k,j));} 
			if(max>1e-10) test = true;
			if(test==false) j++;
		}

		
		//double max = -DBL_MAX;
		//for(int k=i;k<m;k++)
			//if(M[k][j]>max){i0=k; max = M[k][j];} 
		
		if(test){
		//permut_lines(M[i],M[i0],j);
		GVector tmp(n-j+1);
		for(int k=j;k<=n;k++)
			tmp(k-j+1)=M(i,k);
		for(int k=j;k<=n;k++)
			M(i,k)=M(i0,k);
		for(int k=j;k<=n;k++)
			M(i0,k)=tmp(k-j+1);
		
		//multiply_coeff(M[i],1.0/M[i][j]);
		double coeff = 1.0/M(i,j);
		for(int k=1;k<=n;k++)
			M(i,k)*=coeff;
	
		
		for(int k=i+1;k<=m;k++){
			//add_lines(M[k],-M[k][j],M[i]);
			double a = -M(k,j);
			for(int l=1;l<=n;l++)
				M(k,l)+=a*M(i,l);

		}

		}
		i++;
		j++;
      
	   //if(cpt==5) end = true;
	}
	for(int i=1;i<=m;i++)
		for(int j=1;j<=n;j++)
			if(abs(M(i,j))<1e-10) M(i,j)=0;
	
	

	j=n;
	cout<<endl<<endl;
	while(j>1){
		for(int i=m;i>0;i--)
			if(abs(M(i,j)-1)<1e-10){
				
				for(int k=1;k<i;k++){
					//add_lines(M[k],-M[k][j],M[i]);
					double a = -M(k,j);
					for(int l=1;l<=n;l++)
						M(k,l)+=a*M(i,l);
				}
				break;

			}
		j--;
		
	}

	vector<int> independent_columns;
	for(int i=1;i<=m;i++){
		for(int j=1;j<=n;j++)
			if(abs(M(i,j)-1)<1e-10) {independent_columns.push_back(j);break;}
	}

	rank = independent_columns.size();
	if(rank==min(m,n)) complete_rank = true;
	else complete_rank = false;

	for(int j=1;j<=n;j++){
		bool test = true;
		for(int k=0;k<independent_columns.size();k++)
			if(j==independent_columns[k]) {test = false; break;}
		if(test){
			
			
			dependent_columns.push_back(j);

			

		}

	}


	return complete_rank;
}






























